/********************************************************************************
If you should have any comments, suggestions or improvements to these samples,
we welcome you to contact us at SampleCode@melissadata.com also please visit our
developer bulletin board at forum.melissadata.com.
********************************************************************************/

import com.melissadata.*;
import java.io.*;

public class AddressSample {

  public static String the_license = "DEMO";
  public static String datafile_dir = "/usr/melissadata/";

  public static void main(String args[]) throws IOException 
  {
    mdAddr ao = new mdAddr();
    String ResultsString;

    // ********************** LICENSE STRINGS ***********************
    //       To unlock the full function ality of Address Object,   
    //   please call a sales representative at 1-800-MELISSA ext. 3 
    //          (1-800-635-4772 x3) for a license string.          
    //        Without a valid license string, AddressCheck will     
    //                  only verify Nevada addresses.               
    //              REPLACE "DEMO" with LICENSE STRING                    

    //   SetLicenseString will also check for a valid license in the 
    //   MDADDR_LICENSE(Environment) variable. This allows you to  
    //   modify the license without recompiling the project
    // **************************************************************
    boolean test = ao.SetLicenseString(the_license);
    
    // ********************** DATA FILE PATH  ***********************
    //   File location path is set to the default Data File location.  
    //   Change this value if you installed the data files to a        
    //   different folder.                                             
    //   The Data Files Directory must contain the following files:    
    //   mdAddr.dat, mdAddr.lic, mdAddr.nat, and mdAddr.str 
    // **************************************************************
    ao.SetPathToUSFiles(datafile_dir);

    //CASS required add-ons for highest level of validation. Should be used by non-demo users.
    //ao.SetPathToDPVDataFiles(datafile_dir);
    //ao.SetPathToLACSLinkDataFiles(datafile_dir);
    //ao.SetPathToSuiteLinkDataFiles(datafile_dir);
    
    //ao.SetPathToCanadaFiles(datafile_dir);               //Canadian Address Validation Add-on
    //ao.SetPathToRBDIFiles(datafile_dir);                 //Delivery Indicator Add-on (Residence or Business)
    //ao.SetPathToSuiteFinderDataFiles(DataPathLocation);  //AddressPlus Add-on (appends residential suites)
    
    //Initialize Data Files
    mdAddr.ProgramStatus result = ao.InitializeDataFiles();
    
    //Print Initialization Status Results
    System.out.println("**********************************************");    
    System.out.println("    ADDRESS OBJECT JAVA INTERFACE EXAMPLE     ");
    System.out.println("         Set License: " + test);
    System.out.println("        Build number: " + ao.GetBuildNumber());
    System.out.println("       Database Date: " + ao.GetDatabaseDate());
    System.out.println("     Expiration Date: " + ao.GetExpirationDate());
    System.out.println("***********************************************");
    
    //Add-ons
    //System.out.println("Canadian Database Date: " + ao.GetCanadianDatabaseDate());
    //System.out.println("Canadian Expiration Date: " + ao.GetCanadianExpirationDate());
    //System.out.println("RBDI Database Date: " + ao.GetRBDIDatabaseDate());

    if (result != mdAddr.ProgramStatus.ErrorNone)
    {
      //Problem during initialization
      System.out.println("Initialization Error: " + ao.GetInitializeErrorString());
      return;
    }
    
    String input = "";
    BufferedReader stdin = new BufferedReader( new InputStreamReader( System.in ) );
    while (!input.equals("X"))
    {

      //clear previous address from input and output
      ao.ClearProperties();

      System.out.println("\n***** Input Address *****");
      //Get Input
      System.out.print("  Enter Company: ");
      ao.SetCompany(stdin.readLine());
      System.out.print("  Enter Address: ");
      ao.SetAddress(stdin.readLine());
      System.out.print(" Enter Address2: ");
      ao.SetAddress2(stdin.readLine());
      System.out.print("     Enter City: ");
      ao.SetCity(stdin.readLine());
      System.out.print("    Enter State: ");
      ao.SetState(stdin.readLine());
      System.out.print("      Enter Zip: ");
      ao.SetZip(stdin.readLine());
      // For SuiteFinder Add-on
      System.out.print(" Enter LastName: ");
      ao.SetLastName(stdin.readLine());
      
      ao.VerifyAddress();
      
      System.out.println("");
      System.out.println("\n********** Address Output ***********");
      System.out.println("       Company: " + ao.GetCompany());
      System.out.println("       Address: " + ao.GetAddress());
      System.out.println("      Address2: " + ao.GetAddress2());
      System.out.println("         Suite: " + ao.GetSuite());
      System.out.println("          City: " + ao.GetCity());
      System.out.println("         State: " + ao.GetState());
      System.out.println("           Zip: " + ao.GetZip());
      System.out.println("         Plus4: " + ao.GetPlus4());
      System.out.println("");
      
      System.out.println("Results...");  
      ResultsString=ao.GetResults();
      
      if(ResultsString.contains("AS01") || ResultsString.contains("AS02") || ResultsString.contains("AS03"))
      { 
          //the address was verified...
          if(ResultsString.contains("AS01"))
              System.out.println(" AS01: Full Address Matched to Postal Database and is deliverable");
          if(ResultsString.contains("AS02"))
              System.out.println(" AS02: Address street matched to USPS database but a suite was missing or invalid."); 
          if(ResultsString.contains("AS03"))
              System.out.println(" AS03: Valid physical address not serviced by the USPS."); 
      }
      
      //Display additional level of verification/comments
      if(ResultsString.contains("AS09"))
          System.out.println(" AS09: Foreign Postal Code Detected ");
      if(ResultsString.contains("AS10"))
          System.out.println(" AS10: Address Matched to CMRA");
      if(ResultsString.contains("AS13"))
          System.out.println(" AS13: Address has been Updated by LACSLink"); 
      if(ResultsString.contains("AS14"))
          System.out.println(" AS14: Suite Appended by SuiteLink "); 
      if(ResultsString.contains("AS15"))
          System.out.println(" AS15: Suite Appended by SuiteFinder");
      if(ResultsString.contains("AS16"))
          System.out.println(" AS16: Address is vacant. "); 
      if(ResultsString.contains("AS17"))
          System.out.println(" AS17: Alternate delivery.");
      if(ResultsString.contains("AS18"))
          System.out.println(" AS18: Artificially created adresses detected, DPV processing terminated at this point");
      if(ResultsString.contains("AS20"))
          System.out.println(" AS20: Address Deliverable by USPS only "); 
      if(ResultsString.contains("AS21"))
          System.out.println(" AS21: Alternate Address Suggestion Found.");
      if(ResultsString.contains("AS22"))
          System.out.println(" AS22: No Alternate Address Suggestion Found");
      if(ResultsString.contains("AS23"))
          System.out.println(" AS23: Extraneous information found "); 


      // there was an error in verifying the address
      if(ResultsString.contains("AE"))
          System.out.println(" Address could not be verified...");      
      if(ResultsString.contains("AE01"))
          System.out.println(" AE01: Zip Code Error"); 
      if(ResultsString.contains("AE02"))
          System.out.println(" AE02: Unknown Street Error");
      if(ResultsString.contains("AE03"))
          System.out.println(" AE03: Component Mismatch Error");  
      if(ResultsString.contains("AE04"))
          System.out.println(" AE04: Non-Deliverable Address Error");   
      if(ResultsString.contains("AE05"))
          System.out.println(" AE05: Multiple Match Error "); 
      if(ResultsString.contains("AE06"))
          System.out.println(" AE06: Early Warning System Error ");  
      if(ResultsString.contains("AE07"))
          System.out.println(" AE07: Missing Minimum Address Input");  
      if(ResultsString.contains("AE08"))
          System.out.println(" AE08: Suite Range Invalid Error "); 
      if(ResultsString.contains("AE09"))
          System.out.println(" AE09: Suite Range Missing Error"); 
      if(ResultsString.contains("AE10"))
          System.out.println(" AE10: Primary Range Invalid Error");  
      if(ResultsString.contains("AE11"))
          System.out.println(" AE11: Primary Range Missing Error "); 
      if(ResultsString.contains("AE12"))
          System.out.println(" AE12: PO, HC, or RR Box Number Invalid ");
      if(ResultsString.contains("AE13"))
          System.out.println(" AE13: PO, HC, or RR Box Number Missing ");
      if(ResultsString.contains("AE14"))
          System.out.println(" AE14: CMRA Secondary Missing Error");

      // or program can not attempt address lookup 
      if(ResultsString.contains("AE15"))
          System.out.println(" AE15: Demo Mode, valid license required for full processing "); 
      if(ResultsString.contains("AE16"))
          System.out.println(" AE16: Expired Database, Please Update database");
          
      if(ResultsString.contains("AE17"))
          System.out.println(" AE17: Unnecessary Suite Error ");
      if(ResultsString.contains("AE19"))
          System.out.println(" AE19: Max time for FindSuggestion exceeded ");
      if(ResultsString.contains("AE20"))
          System.out.println(" AE20: FindSuggestion cannot be used");
          
      // a change was made to the input data
      if(ResultsString.contains("AC01"))
          System.out.println(" AC01: ZIP Code Change ");
      if(ResultsString.contains("AC02"))
          System.out.println(" AC02: State Change");
      if(ResultsString.contains("AC03"))
          System.out.println(" AC03: City Change"); 
      if(ResultsString.contains("AC04"))
          System.out.println(" AC04: Base/Alternate Change "); 
      if(ResultsString.contains("AC05"))
          System.out.println(" AC05: Alias Name Change");
      if(ResultsString.contains("AC06"))
          System.out.println(" AC06: Address1/Address2 Swap. "); 
      if(ResultsString.contains("AC07"))
          System.out.println(" AC07: Address1/Company Swap.");
      if(ResultsString.contains("AC08"))
          System.out.println(" AC08: Plus4 Change");
      if(ResultsString.contains("AC09"))
          System.out.println(" AC09: Urbanization Change "); 
      if(ResultsString.contains("AC10"))
          System.out.println(" AC10: Street Name Change.");
      if(ResultsString.contains("AC11"))
          System.out.println(" AC11: Street Suffix Change");
      if(ResultsString.contains("AC12"))
          System.out.println(" AC12: Street Directional Change "); 
      if(ResultsString.contains("AC13"))
          System.out.println(" AC13: Suite Name Change "); 
    
           
      
      // Other output properties  
      System.out.println(""); 
      System.out.println("                 Carrier Route: " + ao.GetCarrierRoute());
      System.out.println("           Delivery Point Code: " + ao.GetDeliveryPointCode());
      System.out.println("     Delivery Point CheckDigit: " + ao.GetDeliveryPointCheckDigit());
      System.out.println("                 DPV Footnotes: " + ao.GetDPVFootnotes());
      System.out.println("");
      System.out.println("             Address Type Code: " + ao.GetAddressTypeCode());
      System.out.println("           Address Type String: " + ao.GetAddressTypeString());
      System.out.println("             City Abbreviation: " + ao.GetCityAbbreviation());
      System.out.println("                   County Name: " + ao.GetCountyName());
      System.out.println("                   County Fips: " + ao.GetCountyFips());
      System.out.println("                   CountryCode: " + ao.GetCountryCode());
      System.out.println("        Congressional District: " + ao.GetCongressionalDistrict());
      System.out.println("                     Time Zone: " + ao.GetTimeZone());
      System.out.println("                Time Zone Code: " + ao.GetTimeZoneCode());
      System.out.println("                  Urbanization: " + ao.GetUrbanization());
      System.out.println("                      Zip Type: " + ao.GetZipType());
      System.out.println("");
      System.out.println("          Parsed Address Range: " + ao.GetParsedAddressRange());
      System.out.println("           Parsed PreDirection: " + ao.GetParsedPreDirection());
      System.out.println("            Parsed Street Name: " + ao.GetParsedStreetName());
      System.out.println("                 Parsed Suffix: " + ao.GetParsedSuffix());
      System.out.println("          Parsed PostDirection: " + ao.GetParsedPostDirection());
      System.out.println("             Parsed Suite Name: " + ao.GetParsedSuiteName());
      System.out.println("            Parsed Suite Range: " + ao.GetParsedSuiteRange());
      System.out.println("   Parsed Private Mailbox Name: " + ao.GetParsedPrivateMailboxName());
      System.out.println(" Parsed Private Mailbox Number: " + ao.GetParsedPrivateMailboxNumber());
      System.out.println("                Parsed Garbage: " + ao.GetParsedGarbage());
      System.out.println("");
      System.out.println("                           MSA: " + ao.GetMsa());
      System.out.println("                          PMSA: " + ao.GetPmsa());
      System.out.println("                          CMRA: " + ao.GetCMRA());
      System.out.println("               Private Mailbox: " + ao.GetPrivateMailbox());
      System.out.println("");
      System.out.println("                    ELot Order: " + ao.GetELotOrder());
      System.out.println("                   ELot Number: " + ao.GetELotNumber());
      System.out.println("                          LACS: " + ao.GetLACS());
      System.out.println("            LACSLink Indicator: " + ao.GetLACSLinkIndicator());  //LACSLink add-on
      System.out.println("          LACSLink Return Code: " + ao.GetLACSLinkReturnCode()); //LACSLink add-on
      System.out.println("         SuiteLink Return Code: " + ao.GetLACSLinkReturnCode());
      System.out.println("                          RBDI: " + ao.GetRBDI());               //RBDI add-on      
      System.out.println("                       EWSFlag: " + ao.GetEWSFlag());
      
      System.out.print("\nPress Enter to Continue, X to quit:");
      input = stdin.readLine().toUpperCase();
    } 
    ao.delete();
  }
}
